<?php namespace Visiosoft\BonusModule\Http\Controller\Admin;

use Visiosoft\BonusModule\Interest\Form\InterestFormBuilder;
use Visiosoft\BonusModule\Interest\Table\InterestTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class InterestsController extends AdminController
{
    public function index(InterestTableBuilder $table)
    {
        return $table->render();
    }

    public function create(InterestFormBuilder $form, $type)
    {
        $form->skipField($type === 'month' ? 'date' : 'month');

        $form->setOption('redirect', '/admin/bonus/interests');

        return $form->render();
    }

    public function edit(InterestFormBuilder $form, $type, $id)
    {
        $form->skipField($type === 'month' ? 'date' : 'month');

        return $form->render($id);
    }
}
