<?php namespace Visiosoft\BonusModule\Handler;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class CategoriesOptions
{
    public function handle(RelationshipFieldType $fieldType, CategoryRepositoryInterface $entries) {
        $mainCats = $entries->mainCats();
        $cats = collect();
        foreach ($mainCats as $mainCat) {
            $cats = $cats->concat($entries->getSubCatById($mainCat->id));
        }
        $fieldType->setOptions(
            $cats->pluck('name', 'id')->all()
        );
    }
}