<?php namespace Visiosoft\BonusModule\Bonus;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;

class BonusCriteria extends EntryCriteria
{
    private $bonusRepository;

    public function __construct(
        Builder $query, StreamInterface $stream, $method,
        BonusRepositoryInterface $bonusRepository
    )
    {
        parent::__construct($query, $stream, $method);
        $this->bonusRepository = $bonusRepository;
    }

    public function getCurrentBonus($userId = null)
    {
        return $this->bonusRepository->getCurrentBonus($userId);
    }
}
