<?php namespace Visiosoft\BonusModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class BonusModule extends Module
{
    protected $navigation = true;

    protected $icon = 'fa fa-puzzle-piece';

    protected $sections = [
        'bonuses' => [
            'buttons' => [
                'new_bonus',
            ],
        ],
        'special_days' => [
            'buttons' => [
                'new_special_day',
                'run_special_days' => [
                    'type' => 'info',
                    'href' => "/admin/bonus/special_days/run",
                ],
                'run_users_anniversary' => [
                    'type' => 'danger',
                    'attributes' => [
                        'data-toggle' => 'confirm',
                        'data-icon' => 'warning',
                        'data-title' => 'visiosoft.module.bonus::message.confirm_run_bonus_title',
                        'data-message' => 'visiosoft.module.bonus::message.confirm_run_bonus_message',
                    ],
                    'href' => "/admin/bonus/special_days/anniversary",
                ],
                'run_users_birthday' => [
                    'type' => 'danger',
                    'attributes' => [
                        'data-toggle' => 'confirm',
                        'data-icon' => 'warning',
                        'data-title' => 'visiosoft.module.bonus::message.confirm_run_bonus_title',
                        'data-message' => 'visiosoft.module.bonus::message.confirm_run_bonus_message',
                    ],
                    'href' => "/admin/bonus/special_days/birthday",
                ],
            ],
        ],
        'interests' => [
            'buttons' => [
                'new_interest' => [
                    'href' => "/admin/bonus/interests/create/month",
                ],
                'new_special_day' => [
                    'href' => "/admin/bonus/interests/create/day",
                ],
                'run_monthly_interests_bonus' => [
                    'type' => 'info',
                    'href' => "/admin/bonus/interests/run/month",
                ],
                'run_day_interests_bonus' => [
                    'type' => 'info',
                    'href' => "/admin/bonus/interests/run/day",
                ],
                'run_interests_bonus' => [
                    'type' => 'info',
                    'href' => "/admin/bonus/interests/run/interest",
                ],
            ],
        ],
    ];
}
