<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBonusCreateBonusesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'bonuses',
        'title_column' => 'description',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'description' => [
            'required' => true,
        ],
        'user' => [
            'required' => true,
        ],
        "added_bonus" => [
            'required' => true,
        ],
        "bonus_post_update",
        'status',
    ];

}
