<?php namespace Visiosoft\BonusModule\Listeners;

use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\BonusModule\Listeners\Utilities\BonusCreation;

class CreateRegistrationBonus extends BonusCreation
{
    public function handle(UserHasRegistered $event)
    {
        $this->createBonus(
            trans('visiosoft.module.bonus::field.registration_bonus'),
            $event->getUser()->getId(),
            setting_value('visiosoft.module.bonus::registration_bonus')
        );
    }
}