<?php namespace Visiosoft\BonusModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class BonusModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'bonuses' => [
            'buttons' => [
                'new_bonus',
            ],
        ],
        'special_days' => [
            'buttons' => [
                'new_special_day',
                'run_special_days' => [
                    'type' => 'info',
                    'href' => "/admin/bonus/special_days/run",
                ],
                'run_users_anniversary' => [
                    'type' => 'danger',
                    'attributes' => [
                        'data-toggle' => 'confirm',
                        'data-icon' => 'warning',
                        'data-title' => 'visiosoft.module.bonus::message.confirm_run_anv_bir_title',
                        'data-message' => 'visiosoft.module.bonus::message.confirm_run_anv_bir_message',
                    ],
                    'href' => "/admin/bonus/special_days/anniversary",
                ],
                'run_users_birthday' => [
                    'type' => 'danger',
                    'attributes' => [
                        'data-toggle' => 'confirm',
                        'data-icon' => 'warning',
                        'data-title' => 'visiosoft.module.bonus::message.confirm_run_anv_bir_title',
                        'data-message' => 'visiosoft.module.bonus::message.confirm_run_anv_bir_message',
                    ],
                    'href' => "/admin/bonus/special_days/birthday",
                ],
            ],
        ],
        'interests' => [
            'buttons' => [
                'new_interest',
                'run_interests_bonus' => [
                    'type' => 'info',
                    'href' => "/admin/bonus/interests/run",
                ],
            ],
        ],
    ];
}
