<?php namespace Visiosoft\BonusModule\SpecialDay;

use Carbon\Carbon;
use Visiosoft\BonusModule\SpecialDay\Contract\SpecialDayRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SpecialDayRepository extends EntryRepository implements SpecialDayRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SpecialDayModel
     */
    protected $model;

    /**
     * Create a new SpecialDayRepository instance.
     *
     * @param SpecialDayModel $model
     */
    public function __construct(SpecialDayModel $model)
    {
        $this->model = $model;
    }

    public function getTodaySpecials()
    {
        return $this->newQuery()
            ->whereDate('date', Carbon::today()->toDateString())
            ->where('executed', false)
            ->get();
    }

    public function revertTodayNonSpecialDays()
    {
        $this->newQuery()
            ->whereDate('date', '!=', Carbon::today()->toDateString())
            ->where('executed', true)
            ->update(['executed' => false]);
    }
}
