<?php namespace Visiosoft\BonusModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\BonusModule\Bonus\Form\BonusFormBuilder;
use Visiosoft\BonusModule\Bonus\Table\BonusTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class BonusesController extends AdminController
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        parent::__construct();
        $this->bonusRepository = $bonusRepository;
    }

    /**
     * Display an index of existing entries.
     *
     * @param BonusTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(BonusTableBuilder $table)
    {
        $table->addButtons([
            'status' => [
                'text' => trans('visiosoft.module.bonus::field.approve'),
                'href' => '/admin/bonus/approve/{entry.id}',
                'type' => 'success',
                'disabled' => function (EntryInterface $entry) {
                    return $entry->isApproved();
                },
            ],
            'edit'
        ]);

        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param BonusFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(BonusFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param BonusFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(BonusFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id)
    {
        try {
            $bonus = $this->bonusRepository->find($id);

            if (!$bonus->isApproved()) {
                $currentBonus = $this->bonusRepository->getCurrentBonus($bonus->user_id);
                $bonus->approveBonus($currentBonus);

                $this->messages->success(trans('visiosoft.module.bonus::message.bonus_approved'));
            } else {
                $this->messages->error(trans('visiosoft.module.bonus::message.bonus_already_approved'));
            }
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect()->route('visiosoft.module.bonus::admin_bonus');
    }
}
