<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Listeners\Utilities\BonusCreation;
use Visiosoft\ProfileModule\Events\UserUpdated;

class CreateFillUserInfoBonus extends BonusCreation
{
    public function handle(UserUpdated $event)
    {
        $changes = $event->changes;
        $oldCustomerInfo = $event->oldCustomerInfo;

        if ($changes && count($changes)) {
            foreach ($changes as $fieldName => $change) {
                if (!$oldCustomerInfo[$fieldName]) {
                    $this->createBonus(
                        trans('visiosoft.module.bonus::field.filling_profile_bonus'),
                        $oldCustomerInfo['id'],
                        setting_value('visiosoft.module.bonus::filling_profile_bonus')
                    );
                }
            }
        }
    }
}