<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleBonusCreateBonusFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'description' => 'anomaly.field_type.text',
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                "mode" => "lookup",
            ]
        ],
        "added_bonus" => [
            'type' => "anomaly.field_type.decimal",
            'config' => [
                'min' => null,
                'max' => null
            ]
        ],
        "bonus_post_update" => [
            'type' => "anomaly.field_type.decimal",
            'config' => [
                'min' => null,
                'max' => null
            ]
        ],
        "status" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options"       => [
                    'approved' => 'visiosoft.module.bonus::field.approved',
                    'pending' => 'visiosoft.module.bonus::field.pending'
                ],
                "default_value" => 'pending',
                "mode"          => "dropdown",
            ]
        ],
        "name" => "anomaly.field_type.text",
        "date" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "mode" => "date",
            ]
        ],
        "bonus_to_be_added" => [
            'type' => "anomaly.field_type.decimal",
            'config' => [
                'min' => null,
                'max' => null
            ]
        ],
        "executed" => [
            "type" => "anomaly.field_type.boolean",
            "config" => [
                "default_value" => false,
                "mode" => "checkbox",
            ]
        ],
        "category" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\CatsModule\Category\CategoryModel::class,
                "mode" => "search",
                "handler" => \Visiosoft\BonusModule\Handler\CategoriesOptions::class,
            ]
        ],
        "month" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options" => [
                    1 => 'visiosoft.module.bonus::field.january',
                    2 => 'visiosoft.module.bonus::field.february',
                    3 => 'visiosoft.module.bonus::field.march',
                    4 => 'visiosoft.module.bonus::field.april',
                    5 => 'visiosoft.module.bonus::field.may',
                    6 => 'visiosoft.module.bonus::field.june',
                    7 => 'visiosoft.module.bonus::field.july',
                    8 => 'visiosoft.module.bonus::field.august',
                    9 => 'visiosoft.module.bonus::field.september',
                    10 => 'visiosoft.module.bonus::field.october',
                    11 => 'visiosoft.module.bonus::field.november',
                    12 => 'visiosoft.module.bonus::field.december',
                ],
                "mode" => "dropdown",
            ]
        ]
    ];

}
