<?php namespace Visiosoft\BonusModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\BonusModule\SpecialDay\Contract\SpecialDayRepositoryInterface;

class SpecialDaysController extends PublicController
{
    private $specialDayRepository;
    private $userRepository;
    private $bonusRepository;

    public function __construct(
        SpecialDayRepositoryInterface $specialDayRepository,
        UserRepositoryInterface $userRepository,
        BonusRepositoryInterface $bonusRepository
    )
    {
        parent::__construct();
        $this->specialDayRepository = $specialDayRepository;
        $this->userRepository = $userRepository;
        $this->bonusRepository = $bonusRepository;
    }

    public function run()
    {
        try {
            $todaySpecials = $this->specialDayRepository->getTodaySpecials();

            $customers = $this->userRepository->all();

            foreach ($customers as $customer) {
                foreach ($todaySpecials as $day) {
                    $this->bonusRepository->createBonus(
                        $day->name,
                        $day->bonus_to_be_added,
                        $customer->id
                    );

                    $day->execute();
                }
            }

            $this->specialDayRepository->revertTodayNonSpecialDays();

            $this->messages->success("visiosoft.module.bonus::message.special_days_added_success");
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect()->route('visiosoft.module.bonus::admin_special_days');
    }

    public function anniversary()
    {
        try {
            $customers = $this->userRepository->newQuery()
                ->whereRaw("DATE_FORMAT(created_at, '%m-%d') = ?", [date('m-d')])
                ->get();

            foreach ($customers as $customer) {
                $this->bonusRepository->createBonus(
                    trans('visiosoft.module.bonus::field.annual_anniversary_bonus'),
                    setting_value('visiosoft.module.bonus::annual_anniversary_bonus'),
                    $customer->id
                );
            }

            $this->messages->success(trans('visiosoft.module.bonus::message.anniversary_bonus_added_success'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect()->route('visiosoft.module.bonus::admin_special_days');
    }
}
