<?php namespace Visiosoft\BonusModule\Helpers;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;

class PayingForOptions
{
    public function handle(CheckboxesFieldType $fieldType)
    {
        $buyables = get_buyables();

        $enabledBuyables = array();
        foreach ($buyables as $key => $buyable) {
            if (is_module_installed("visiosoft.module.$key")) {
                $enabledBuyables[$buyable['entry_type']] = $buyable['name'];
            }
        }

        $fieldType->setOptions($enabledBuyables);
    }
}