<?php namespace Visiosoft\BonusModule\Bonus;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class BonusRepository extends EntryRepository implements BonusRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var BonusModel
     */
    protected $model;

    /**
     * Create a new BonusRepository instance.
     *
     * @param BonusModel $model
     */
    public function __construct(BonusModel $model)
    {
        $this->model = $model;
    }

    public function getCurrentBonus($userId = null)
    {
        $userId = $userId ?: auth()->id();

        return $this->newQuery()
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->sum('added_bonus');
    }

    public function createBonus($description, $addedBonus, $userId = null, $status = 'approved')
    {
        $userId = $userId ?: auth()->id();
        $currentBonus = $this->getCurrentBonus($userId);

        $this->create([
            'description' => $description,
            'user_id' => $userId,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => $status,
        ]);
    }

    public function getUserBonuses($userId = null)
    {
        $userId = $userId ? $userId : auth()->id();

        return $this->newQuery()
            ->where('user_id', $userId)
            ->orderByDesc('created_at');
    }
}
