<?php namespace Visiosoft\BonusModule\Listeners\Utilities;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;

class BonusCreation
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function createBonus($description, $userId, $addedBonus)
    {
        $currentBonus = $this->bonusRepository->getCurrentBonus($userId);

        $this->bonusRepository->createBonus([
            'description' => $description,
            'user_id' => $userId,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => 'approved',
        ]);
    }
}