<?php namespace Visiosoft\BonusModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Bonus\BonusBonusesEntryModel;
use Anomaly\Streams\Platform\Model\Bonus\BonusInterestsEntryModel;
use Anomaly\Streams\Platform\Model\Bonus\BonusSpecialDaysEntryModel;
use Visiosoft\BonusModule\Bonus\BonusModel;
use Visiosoft\BonusModule\Bonus\BonusRepository;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\BonusModule\Interest\Contract\InterestRepositoryInterface;
use Visiosoft\BonusModule\Interest\InterestModel;
use Visiosoft\BonusModule\Interest\InterestRepository;
use Visiosoft\BonusModule\SpecialDay\Contract\SpecialDayRepositoryInterface;
use Visiosoft\BonusModule\SpecialDay\SpecialDayModel;
use Visiosoft\BonusModule\SpecialDay\SpecialDayRepository;

class BonusModuleServiceProvider extends AddonServiceProvider
{
    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        // Admin BonusesController
        'admin/bonus' => [
            'as' => 'visiosoft.module.bonus::admin_bonus',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@index'
        ],
        'admin/bonus/create' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@create',
        'admin/bonus/edit/{id}' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@edit',
        'admin/bonus/approve/{id}' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@approve',

        // SpecialDaysController
        'admin/bonus/special_days' => [
            'as' => 'visiosoft.module.bonus::admin_special_days',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\Admin\SpecialDaysController@index',
        ],
        'admin/bonus/special_days/run' => 'Visiosoft\BonusModule\Http\Controller\SpecialDaysController@run',
        'admin/bonus/special_days/anniversary' => 'Visiosoft\BonusModule\Http\Controller\SpecialDaysController@anniversary',
        'admin/bonus/special_days/birthday' => 'Visiosoft\BonusModule\Http\Controller\SpecialDaysController@birthday',

        // Bonuses Controller
        'bonuses' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bonus::bonuses',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\BonusesController@index',
        ],
        'bonus/pay' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bonus::bonus_pay',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\BonusesController@payWithBonus',
        ],

        // Admin InterestController
        'admin/bonus/interests' => [
            'as' => 'visiosoft.module.bonus::admin_bonus_interests',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\Admin\InterestsController@index',
        ],

        // InterestController
        'admin/bonus/interests/run' => 'Visiosoft\BonusModule\Http\Controller\InterestsController@run'
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        // Adding bonus
        'Visiosoft\PackagesModule\Events\PackageApproved' => [ // Package bonus
            'Visiosoft\BonusModule\Listeners\CreatePackageBonus'
        ],
        'Visiosoft\DopingsModule\Events\DopingApproved' => [ // Doping bonus
            'Visiosoft\BonusModule\Listeners\CreateDopingBonus'
        ],
        'Anomaly\UsersModule\User\Event\UserHasRegistered' => [ // Registration bonus
            'Visiosoft\BonusModule\Listeners\CreateRegistrationBonus'
        ],
        'Visiosoft\ProfileModule\Events\UserActivatedByMail' => [ // Email activation bonus
            'Visiosoft\BonusModule\Listeners\CreateEmailActivationBonus'
        ],
        'Visiosoft\ProfileModule\Events\UserUpdated' => [ // Filling profile bonus
            'Visiosoft\BonusModule\Listeners\CreateFillUserInfoBonus'
        ],
        'Visiosoft\StoreModule\Events\StoreWasCreated' => [ // Store creation bonus
            'Visiosoft\BonusModule\Listeners\CreateStoreCreationBonus'
        ],
        'Visiosoft\ReferencesModule\Events\ReferenceWasCreated' => [ // Reference bonus
            'Visiosoft\BonusModule\Listeners\CreateReferenceBonus'
        ],
        'Visiosoft\InterestsModule\Events\UserInterestsWasCreated' => [ // Interests bonus
            'Visiosoft\BonusModule\Listeners\CreateInterestsBonus'
        ],
        'Visiosoft\SocialModule\Events\SocialRegisterWasCreated' => [ // Social Register bonus
            'Visiosoft\BonusModule\Listeners\CreateSocialRegistrationBonus'
        ],
        'Visiosoft\SmsVerificationModule\Events\GsmVerified' => [ // Gsm Verification bonus
            'Visiosoft\BonusModule\Listeners\CreateGsmVerificationBonus'
        ],

        // Others
        'Visiosoft\CartsModule\Cart\Event\CartsPay' => [
            'Visiosoft\BonusModule\Listeners\PaymentType',
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BonusBonusesEntryModel::class => BonusModel::class,
        BonusSpecialDaysEntryModel::class => SpecialDayModel::class,
        BonusInterestsEntryModel::class => InterestModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        BonusRepositoryInterface::class => BonusRepository::class,
        SpecialDayRepositoryInterface::class => SpecialDayRepository::class,
        InterestRepositoryInterface::class => InterestRepository::class,
    ];
}
