<?php namespace Visiosoft\BonusModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\BonusModule\Interest\Contract\InterestRepositoryInterface;

class InterestsController extends PublicController
{
    public function run(
        $type,
        InterestRepositoryInterface $bonusInterestRepository,
        \Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface $interestRepository,
        BonusRepositoryInterface $bonusRepository
    )
    {
        try {
            if ($type !== 'month' && $type !== 'interest' && $type !== 'day') {
                throw new \Exception('visiosoft.module.bonus::message.invalid_url');
            }

            $time = null;
            if ($type === 'month') {
                $time = date('n');
            } elseif ($type === 'day') {
                $time = Carbon::today();
            } else {
                $type = null;
            }
            $interestsBonuses = $bonusInterestRepository->getInterestsBonuses($time, $type);

            foreach ($interestsBonuses as $interestBonus) {
                $interestsUsers = $interestRepository->findAllByCatID($interestBonus->category_id)->pluck('user_id');

                foreach ($interestsUsers as $userID) {
                    $bonusRepository->createBonus(
                        $interestBonus->name,
                        $interestBonus->bonus_to_be_added,
                        $userID
                    );
                }

                if ($time) {
                    $interestBonus->execute();
                }
            }

            if ($time) {
                $bonusInterestRepository->revertNonCurrTime($type);
            }

            $this->messages->success(trans('visiosoft.module.bonus::message.interest_bonus_added'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect()->route('visiosoft.module.bonus::admin_bonus_interests');
    }
}
