$(document).ready( function () {
    $('#topBonusReport').DataTable({
        ajax: {
            url: '/admin/api/bonus/report/bonus',
            dataSrc( json ) {
                json.recordsTotal = json.total;
                json.recordsFiltered = json.total;

                return json.data;
            }
        },
        order: [[ 1, "desc" ]],
        processing: true,
        serverSide: true,
        columns: [
            {
                data: 'member',
                render: function ( data, type, row, meta ) {
                    return `
                        <a href="/admin/users/edit/${row.user_id}" class="text-info">
                            ${data ? data : bonusReportTrans.undefined_member}
                        </a>
                    `;
                }
            },
            { data: 'bonus' },
        ],
    });
} );
