<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Listeners\Utilities\BonusCreation;
use Visiosoft\ProfileModule\Events\UserUpdated;

class CreateFillUserInfoBonus extends BonusCreation
{
    public function handle(UserUpdated $event)
    {
        $changes = $event->changes;
        $oldCustomerInfo = $event->oldCustomerInfo;

        if ($changes && count($changes)) {
	        if ($changes['facebook_address']){
		        if (!$oldCustomerInfo['facebook_address']) {

			        $this->createBonus(
				        trans('visiosoft.module.bonus::field.facebook_address_bonus'),
				        $oldCustomerInfo['id'],
				        setting_value('visiosoft.module.bonus::facebook_address_bonus')
			        );
		        }
	        }

	        if ($changes['google_address']){
		        if (!$oldCustomerInfo['google_address']) {
			        $this->createBonus(
				        trans('visiosoft.module.bonus::field.google_address_bonus'),
				        $oldCustomerInfo['id'],
				        setting_value('visiosoft.module.bonus::google_address_bonus')
			        );
		        }
	        }

            foreach ($changes as $fieldName => $change) {
                if (!$oldCustomerInfo[$fieldName]) {
                    $this->createBonus(
                        trans('visiosoft.module.bonus::field.filling_profile_bonus'),
                        $oldCustomerInfo['id'],
                        setting_value('visiosoft.module.bonus::filling_profile_bonus')
                    );
                }
            }
        }
    }
}