<?php namespace Visiosoft\BonusModule\Listeners;

use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;

class CreateRegistrationBonus
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function handle(UserHasRegistered $event)
    {
        $addedBonus = setting_value('visiosoft.module.bonus::registration_bonus');

        $this->bonusRepository->createBonus([
            'description' => trans('visiosoft.module.bonus::field.registration_bonus'),
            'user_id' => $event->getUser()->getId(),
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $addedBonus,
            'status' => 'approved',
        ]);
    }
}