<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\DopingsModule\Events\DopingApproved;

class CreateDopingBonus
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function handle(DopingApproved $event)
    {
        $currentBonus = $this->bonusRepository->getCurrentBonus($event->doping->user_id);

        $this->bonusRepository->createBonus([
            'description' => trans('visiosoft.module.bonus::field.doping_creation_bonus'),
            'user_id' => $event->doping->user_id,
            'added_bonus' => $event->doping->price,
            'bonus_post_update' => $currentBonus + $event->doping->price,
            'status' => 'approved',
        ]);
    }
}