<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleBonusCreateBonusFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'description' => 'anomaly.field_type.text',
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                "mode" => "lookup",
            ]
        ],
        "added_bonus" => [
            'type' => "anomaly.field_type.decimal",
            'config' => [
                'min' => null,
                'max' => null
            ]
        ],
        "bonus_post_update" => [
            'type' => "anomaly.field_type.decimal",
            'config' => [
                'min' => null,
                'max' => null
            ]
        ],
        "status" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options"       => [
                    'approved' => 'visiosoft.module.bonus::field.approved',
                    'pending' => 'visiosoft.module.bonus::field.pending'
                ],
                "default_value" => 'pending',
                "mode"          => "dropdown",
            ]
        ]
    ];

}
