<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\StoreModule\Events\StoreWasCreated;

class CreateStoreCreationBonus
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function handle(StoreWasCreated $event)
    {
        $currentBonus = $this->bonusRepository->getCurrentBonus($event->store->user_id);
        $addedBonus = setting_value('visiosoft.module.bonus::store_creation_bonus');

        $this->bonusRepository->createBonus([
            'description' => trans('visiosoft.module.bonus::field.store_creation_bonus'),
            'user_id' => $event->store->user_id,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => 'approved',
        ]);
    }
}