<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\ReferencesModule\Events\ReferenceWasCreated;

class CreateReferenceBonus
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function handle(ReferenceWasCreated $event)
    {
        $currentBonus = $this->bonusRepository->getCurrentBonus($event->reference->referenced_user_id);
        $addedBonus = setting_value('visiosoft.module.bonus::reference_bonus');

        $this->bonusRepository->createBonus([
            'description' => trans('visiosoft.module.bonus::field.reference_bonus'),
            'user_id' => $event->reference->referenced_user_id,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => 'approved',
        ]);
    }
}