<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\PackagesModule\Events\PackageApproved;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;

class CreatePackageBonus
{
    private $bonusRepository;
    private $userPackageRepository;

    public function __construct(
        BonusRepositoryInterface $bonusRepository,
        UserRepositoryInterface $userPackageRepository
    )
    {
        $this->bonusRepository = $bonusRepository;
        $this->userPackageRepository = $userPackageRepository;
    }

    public function handle(PackageApproved $event)
    {
        $addedBonus = $event->userPackage->package->price;
        $currentBonus = $this->bonusRepository->getCurrentBonus($event->userPackage->user_id);

        $bonuses = [
            [
                'description' => trans('visiosoft.module.bonus::field.package_creation_bonus'),
                'user_id' => $event->userPackage->user_id,
                'added_bonus' => $addedBonus,
                'bonus_post_update' => $currentBonus + $addedBonus,
                'status' => 'approved',
            ],
        ];

        // Check if first package
        $userPackages = $this->userPackageRepository->getUserPackages($event->userPackage->user_id);
        $isFirstPackage = count($userPackages) === 1 ? true : false;
        if ($isFirstPackage) {
            $firstPackageBonus = setting_value('visiosoft.module.bonus::first_package_bonus');
            $bonuses[] = [
                'description' => trans('visiosoft.module.bonus::field.first_package_creation_bonus'),
                'user_id' => $event->userPackage->user_id,
                'added_bonus' => $firstPackageBonus,
                'bonus_post_update' => $firstPackageBonus + $currentBonus + $addedBonus,
                'status' => 'approved',
            ];
        }

        foreach ($bonuses as $bonus) {
            $this->bonusRepository->createBonus($bonus);
        }
    }
}