<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\InterestsModule\Events\userInterestsWasCreated;

class CreateInterestsBonus
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function handle(userInterestsWasCreated $event)
    {
        $currentBonus = $this->bonusRepository->getCurrentBonus($event->interests->user_id);
        $addedBonus = setting_value('visiosoft.module.bonus::interests_creation_bonus');

        $this->bonusRepository->createBonus([
            'description' => trans('visiosoft.module.bonus::field.interests_creation_bonus'),
            'user_id' => $event->interests->user_id,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => 'approved',
        ]);
    }
}