<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\ProfileModule\Events\UserActivatedByMail;

class CreateEmailActivationBonus
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        $this->bonusRepository = $bonusRepository;
    }

    public function handle(UserActivatedByMail $event)
    {
        $currentBonus = $this->bonusRepository->getCurrentBonus($event->user->id);
        $addedBonus = setting_value('visiosoft.module.bonus::mail_activation_bonus');

        $this->bonusRepository->createBonus([
            'description' => trans('visiosoft.module.bonus::field.mail_activation_bonus'),
            'user_id' => $event->user->id,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => 'approved',
        ]);
    }
}