<?php namespace Visiosoft\BonusModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Bonus\BonusBonusesEntryModel;
use Anomaly\Streams\Platform\Model\Bonus\BonusSpecialDaysEntryModel;
use Illuminate\Routing\Router;
use Visiosoft\BonusModule\Bonus\BonusModel;
use Visiosoft\BonusModule\Bonus\BonusRepository;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\BonusModule\SpecialDay\Contract\SpecialDayRepositoryInterface;
use Visiosoft\BonusModule\SpecialDay\SpecialDayModel;
use Visiosoft\BonusModule\SpecialDay\SpecialDayRepository;

class BonusModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        // Admin BonusesController
        'admin/bonus' => [
            'as' => 'visiosoft.module.bonus::admin_bonus',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@index'
        ],
        'admin/bonus/create' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@create',
        'admin/bonus/edit/{id}' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@edit',
        'admin/bonus/approve/{id}' => 'Visiosoft\BonusModule\Http\Controller\Admin\BonusesController@approve',

        // SpecialDaysController
        'admin/bonus/special_days' => [
            'as' => 'visiosoft.module.bonus::admin_special_days',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\Admin\SpecialDaysController@index',
        ],
        'admin/bonus/special_days/run' => 'Visiosoft\BonusModule\Http\Controller\SpecialDaysController@run',
        'admin/bonus/special_days/anniversary' => 'Visiosoft\BonusModule\Http\Controller\SpecialDaysController@anniversary',

        // Bonuses Controller
        'bonuses' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bonus::bonuses',
            'uses' => 'Visiosoft\BonusModule\Http\Controller\BonusesController@index',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BonusModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BonusModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        'Visiosoft\PackagesModule\Events\PackageApproved' => [ // Package bonus
            'Visiosoft\BonusModule\Listeners\CreatePackageBonus'
        ],
        'Visiosoft\DopingsModule\Events\DopingApproved' => [ // Doping bonus
            'Visiosoft\BonusModule\Listeners\CreateDopingBonus'
        ],
        'Anomaly\UsersModule\User\Event\UserHasRegistered' => [ // Registration bonus
            'Visiosoft\BonusModule\Listeners\CreateRegistrationBonus'
        ],
        'Visiosoft\ProfileModule\Events\UserActivatedByMail' => [ // Email activation bonus
            'Visiosoft\BonusModule\Listeners\CreateEmailActivationBonus'
        ],
        'Visiosoft\ProfileModule\Events\UserUpdated' => [ // Filling profile bonus
            'Visiosoft\BonusModule\Listeners\CreateFillUserInfoBonus'
        ],
        'Visiosoft\StoreModule\Events\StoreWasCreated' => [ // Store creation bonus
            'Visiosoft\BonusModule\Listeners\CreateStoreCreationBonus'
        ],
        'Visiosoft\ReferencesModule\Events\ReferenceWasCreated' => [ // Reference bonus
            'Visiosoft\BonusModule\Listeners\CreateReferenceBonus'
        ],
        'Visiosoft\InterestsModule\Events\UserInterestsWasCreated' => [ // Interests bonus
            'Visiosoft\BonusModule\Listeners\CreateInterestsBonus'
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BonusModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BonusBonusesEntryModel::class => BonusModel::class,
        BonusSpecialDaysEntryModel::class => SpecialDayModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        BonusRepositoryInterface::class => BonusRepository::class,
        SpecialDayRepositoryInterface::class => SpecialDayRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
