<?php namespace Visiosoft\BonusModule\Interest;

use Carbon\Carbon;
use Visiosoft\BonusModule\Interest\Contract\InterestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class InterestRepository extends EntryRepository implements InterestRepositoryInterface
{
    protected $model;

    public function __construct(InterestModel $model)
    {
        $this->model = $model;
    }

    /*
     * $month is the month number 1, 2, ..., 12
     * $time && $type should be both null || both not null
     */
    public function getInterestsBonuses($time = null, $type = null)
    {
        if ($time && !$type || $type && !$time) {
            throw new \Exception('Poor usage of getInterestsBonuses!');
        }

        $bonuses = $this->newQuery()->where('executed', false);

        if ($type === 'month') {
            $bonuses = $bonuses->where('month', $time);
        } elseif ($type === 'day') {
            $bonuses = $bonuses->whereDate('date', $time);
        } else {
            $bonuses = $bonuses
                ->whereNull('date')
                ->whereNull('month');
        }

        return $bonuses->get();
    }

    public function revertNonCurrTime($type = 'month')
    {
        $bonus = $this->newQuery()->where('executed', true);

        if ($type === 'month') {
            $bonus = $bonus->where('month', '!=', date('n'));
        } elseif ($type === 'day') {
            $bonus = $bonus->whereDate('date', '!=', Carbon::today());
        }

        $bonus->update(['executed' => false]);
    }
}
