<?php namespace Visiosoft\BonusModule\Bonus;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class BonusRepository extends EntryRepository implements BonusRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var BonusModel
     */
    protected $model;

    /**
     * Create a new BonusRepository instance.
     *
     * @param BonusModel $model
     */
    public function __construct(BonusModel $model)
    {
        $this->model = $model;
    }

    public function getCurrentBonus($userId = null)
    {
        $userId = $userId ?: auth()->id();

        return $this->newQuery()
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->sum('added_bonus');
    }

    public function createBonus($description, $addedBonus, $userId = null, $status = 'approved')
    {
        $userId = $userId ?: auth()->id();
        $currentBonus = $this->getCurrentBonus($userId);

        $this->create([
            'description' => $description,
            'user_id' => $userId,
            'added_bonus' => $addedBonus,
            'bonus_post_update' => $currentBonus + $addedBonus,
            'status' => $status,
        ]);
    }

    public function getUserBonuses($userId = null, $startDate = null, $endDate = null)
    {
        $userId = $userId ? $userId : auth()->id();

        $bonuses = $this->newQuery();

        if ($startDate) {
            $bonuses = $bonuses->where('created_at', '>=', $startDate);
        }

        if ($endDate) {
            $bonuses = $bonuses->where('created_at', '<=', $endDate);
        }

        return $bonuses
            ->where('user_id', $userId)
            ->orderByDesc('created_at');
    }

    public function topMembersReport()
    {
        $bonuses = $this->newQuery()
            ->selectRaw("SUM(added_bonus) as bonus, CONCAT_WS('', first_name, ' ', last_name) AS member, user_id")
            ->where('status', 'approved')
            ->groupBy('user_id')
            ->leftJoin('users_users as users', 'bonus_bonuses.user_id', '=', 'users.id');

        if ($search = request('search.value')) {
            $bonuses = $bonuses->whereRaw("
                (SELECT CONCAT_WS('', first_name, ' ', last_name) AS member FROM default_users_users WHERE id = user_id) LIKE '%$search%'
            ");
        }

        if ($orderDir = request('order.0.dir')) {
            $bonuses = $bonuses->orderBy(request('order.0.column') == 1 ? 'bonus' : 'member', $orderDir);
        }

        $start = request('start');
        $limit = request('length') ?: 10;
        $page = $start ? $start / $limit + 1 : 1;

        return $bonuses->paginate($limit, ['*'], 'page', $page);
    }
}
