<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBonusCreateInterestsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'interests',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'category' => [
            'required' => true,
        ],
        'month',
        'date',
        'bonus_to_be_added' => [
            'required' => true,
        ],
        'executed',
    ];

}
