<?php namespace Visiosoft\BonusModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;

class BonusesController extends PublicController
{
    private $bonusRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository)
    {
        parent::__construct();
        $this->bonusRepository = $bonusRepository;
    }

    public function index()
    {
        $myBonuses = $this->bonusRepository->getUserBonuses();

        return view('visiosoft.module.bonus::bonuses')->with('myBonuses', $myBonuses);
    }
}
