<?php namespace Visiosoft\BonusModule\Bonus;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class BonusRepository extends EntryRepository implements BonusRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var BonusModel
     */
    protected $model;

    /**
     * Create a new BonusRepository instance.
     *
     * @param BonusModel $model
     */
    public function __construct(BonusModel $model)
    {
        $this->model = $model;
    }

    public function getCurrentBonus($userId)
    {
        $currentBonus = $this->newQuery()
            ->select('bonus_post_update')
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->latest('created_at')
            ->first();

        return $currentBonus ? $currentBonus->bonus_post_update : 0;
    }

    public function createBonus($attributes)
    {
        return $this->create($attributes);
    }

    public function getUserBonuses($userId = null)
    {
        $userId = $userId ? $userId : auth()->id();

        return $this->newQuery()
            ->where('user_id', $userId)
            ->orderByDesc('created_at')
            ->get();
    }
}
