<?php namespace Visiosoft\BitmezatTheme\Handler;

use Carbon\Carbon;
use Visiosoft\AuctionsModule\LiveTime\Contract\LiveTimeRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class getLiveAdsByCategory
{
    protected $category_id;

    public function __construct($category_id)
    {
        $this->category_id = $category_id;
    }

    public function handle(
        CustomFieldRepositoryInterface $customFieldRepository,
        LiveTimeRepositoryInterface $liveTimeRepository)
    {
        $category_time_entry = $liveTimeRepository->getLiveTimeByCategory($this->category_id);

        $start_time = ($category_time_entry) ? $category_time_entry->start_time->format('H:i:s') : '19:00:00';
        $end_time = ($category_time_entry) ? $category_time_entry->end_time->format('H:i:s') : '20:00:00';

        $start_time = Carbon::make(Carbon::now()->format('Y-m-d ') . $start_time);
        $end_time = Carbon::make(Carbon::now()->format('Y-m-d ') . $end_time);

        // Find live stream postings today
        $ads = $customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereBetween('publish_at', [
                now()->subDays(7)->format('Y-m-d 00:00'),
                now()->subDays(7)->format('Y-m-d 23:59')
            ])
            ->where('cat1', $this->category_id)
            ->get();

        if (count($ads)) {
            if ($start_time->format('U') < Carbon::now()->format('U') && Carbon::now()->format('U') < $end_time->format('U')) {
                // Listings currently live
                return [
                    'count' => count($ads),
                    'entries' => $ads,
                    'is_live' => true,
                    'remaining_timestamp' => $end_time->format('U')- Carbon::now()->format('U'),

                ];
            } else if (Carbon::now()->format('U') < $start_time->format('U')) {
                // Ads expected for live broadcast
                return [
                    'count' => count($ads),
                    'entries' => $ads,
                    'is_live' => false,
                    'remaining_timestamp' => Carbon::now()->format('U') - $start_time->format('U')
                ];
            } else {
                // live streams expired ads
                false;
            }
        } else {
            // No live broadcast posting found!
            return false;
        }
    }
}
