<?php namespace Visiosoft\BitmezatTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\BitmezatTheme\Handler\getCategoriesAds;
use Visiosoft\BitmezatTheme\Handler\getLiveAdsByCategory;

class BitmezatThemePlugin extends Plugin
{

    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getLiveAdsByCategory',
                function ($category_id) {
                    return $this->dispatch(new getLiveAdsByCategory($category_id));
                }
            ),
            new \Twig_SimpleFunction(
                'getCategoriesAds',
                function ($cat2) {
                    return $this->dispatch(new getCategoriesAds($cat2));
                }
            )
        ];
    }
}
