$('.another-p-slider').slick({
    dots: false,
    infinite: false,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    autoplay: true,
    autoplaySpeed: 2500,
    responsive: [
        {
            breakpoint: 1200,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: true,
                dots: true
            }
        },
        {
            breakpoint: 992,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2
            }
        },
        {
            breakpoint: 768,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }]
});

let offer = {
    send: function () {
        let price = $('#bid_price').val();
        let adv_id = $('#bid_price').data('id');

        crudAjax({'adv_id': adv_id, 'bid_price': price}, '/ajax/create-offer', 'POST', function (r) {
            $.each(r.messages, function (i, message) {
                Toast.fire(message, (!r.status) ? 'error' : 'success');
            });
        });
    },
    refresh: function (id) {
        crudAjax({}, '/ajax/auction/last/' + id + '?type=view', 'GET', function (r) {
            $('#last-offers').html(r);
        });
    },
    setActive: function () {
        let offer_id = $('.active-price').data('id');

        // Set price

        let active_price = ($('.active-price').length > 0) ? $('.active-price').html() : $('.start-price').html();

        $('.active-price-area').html(active_price);

        // set offer_id
        $('#completeSaleBtn').attr('data-offer', offer_id);
    },
    completeSale: function () {
        let offer_id = $('#completeSaleBtn').data('offer');

        crudAjax({}, '/ajax/complete-sold/' + offer_id, 'GET', function (r) {
            window.location.href = r.redirect;
        });
    }
};


setInterval(function () {
    offer.refresh(offer_setting.id);
    offer.setActive();
}, 1000);
