<?php namespace Visiosoft\BitmezatTheme\Handler;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class getLiveCategory
{
    public function handle(AdvRepositoryInterface $advRepository, CategoryRepositoryInterface $categoryRepository)
    {
        $categories = $advRepository
            ->currentAds()
            ->where('publish_at', '<', now()->subDays(8))
            ->where('publish_at', '>', now()->subDays(9))
            ->whereNotNull('cat1')
            ->groupBy('cat1')
            ->pluck('cat1');

        return $categoryRepository->newQuery()->whereIn('id', $categories)->get();
    }
}
