<?php namespace Visiosoft\BitmezatTheme\Handler;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class getLiveCategory
{
    public function handle(CustomFieldRepositoryInterface $customFieldRepository, CategoryRepositoryInterface $categoryRepository)
    {
        $categories = $customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereBetween('publish_at', [
                now()->subDays(8)->format('Y-m-d 23:59'),
                now()->subDays(6)->format('Y-m-d 00:00')
            ])
            ->whereNotNull('cat1')
            ->groupBy('cat1')
            ->pluck('cat1');

        return $categoryRepository->newQuery()->whereIn('id', $categories)->get();
    }
}
