<?php namespace Visiosoft\BiolifeTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\TypeRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterGridBannersEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CatsModule\Category\CategoryModel;
use Anomaly\PostsModule\Type\TypeRepository as postTypeRepository;

class BiolifeThemeSeeder extends Seeder
{
	private $fieldRepository;
	private $advModel;
	private $streamRepository;
	private $assignmentRepository;
	private $areas;
	private $typeRepository;
	private $postTypeRepository;

	public function __construct(
		FieldRepositoryInterface $fieldRepository,
		AdvModel $advModel,
		StreamRepositoryInterface $streamRepository,
		AssignmentRepositoryInterface $assignmentRepository,
		AreaRepository $areas,
		TypeRepository $typeRepository,
		postTypeRepository $postTypeRepository
	)
	{
		parent::__construct();
		$this->fieldRepository = $fieldRepository;
		$this->advModel = $advModel;
		$this->streamRepository = $streamRepository;
		$this->assignmentRepository = $assignmentRepository;
		$this->areas = $areas;
		$this->typeRepository = $typeRepository;
		$this->postTypeRepository = $postTypeRepository;
	}

	public function run()
	{
		$sliderStream = $this->streamRepository->findBySlugAndNamespace('sliders', 'slider');

		if ($this->advModel->is_enabled('slider') && !$this->fieldRepository->findBySlugAndNamespace('content', 'slider')) {
			$field = $this->fieldRepository->create([
				'name' => 'Content',
				'namespace' => 'slider',
				'slug' => 'content',
				'type' => 'anomaly.field_type.wysiwyg',
				'locked' => 0,
			]);

			$this->assignmentRepository->create([
				'stream_id' => $sliderStream->getId(),
				'field_id' => $field->id,
				'label' => 'content',
				'translatable' => true,
			]);
		}

		// Seeders For Block
		$areas = [
			[
				'en' => [
					'name' => 'Grid Banners'
				],
				'slug' => 'grid-banner',
			], [
				'en' => [
					'name' => 'Special Offer',
				],
				'slug' => 'special-offer',
			], [
				'en' => [
					'name' => 'Banner Promotion',
				],
				'slug' => 'banner-promotion',
			], [
				'en' => [
					'name' => 'Advance Product',
				],
				'slug' => 'advance-product'
			], [
				'en' => [
					'name' => 'Brands',
				],
				'slug' => 'brands'
			]
		];

		foreach ($areas as $area) {
			if (!$this->areas->findBySlug($area['slug'])) {
				$this->areas->create($area);
			}
		}

		$types = [
			[
				'name' => 'Grid Banners',
				'slug' => 'grid_banners',
			], [
				'name' => 'Special Offer',
				'slug' => 'special_offer',
			], [
				'name' => 'Banner Promotion',
				'slug' => 'banner_promotion',
			], [
				'name' => 'Advance Product',
				'slug' => 'advance_product'
			], [
				'name' => 'Brands',
				'slug' => 'brands',
			]
		];

		foreach ($types as $type) {
			$exist_type = $this->typeRepository->findBySlug($type['slug']);
			if (!$exist_type) {
				$this->typeRepository->create([
					'category' => 'other',
					'slug' => $type['slug'],
					'name' => $type['name'],
				]);
			}
		}


		//Assign Fields
		$blockFields = [
			[
				'name' => 'Subtitle',
				'slug' => 'subtitle',
				'namespace' => 'blocks',
				'streams' => ['banner_promotion'],
				'type' => 'anomaly.field_type.text',
				'translatable' => false,
				'config' => []
			], [
				'name' => 'Image',
				'slug' => 'image',
				'namespace' => 'blocks',
				'streams' => [
					'grid_banners',
					'special_offer',
					'banner_promotion',
					'advance_product',
					'brands',
				],
				'type' => 'anomaly.field_type.file',
				'translatable' => false,
				'config' => [
					'folders' => ['images'],
					'mode' => 'upload',
				],
			], [
				'name' => 'Grid Category',
				'slug' => 'grid_category',
				'namespace' => 'blocks',
				'streams' => [
					'grid_banners',
				],
				'type' => 'anomaly.field_type.relationship',
				'translatable' => false,
				'config' => [
					'related' => CategoryModel::class,
				],
			], [
				'name' => 'Ad',
				'slug' => 'ad',
				'namespace' => 'blocks',
				'streams' => ['special_offer'],
				'type' => 'anomaly.field_type.relationship',
				'translatable' => false,
				'config' => [
					'related' => AdvModel::class,
				]
			], [
				'name' => 'Ads',
				'slug' => 'ads',
				'namespace' => 'blocks',
				'streams' => ['advance_product'],
				'type' => 'anomaly.field_type.checkboxes',
				'translatable' => false,
				'config' => [
					'handler' => 'Visiosoft\AdvsModule\OptionHandler\AdvsOptions@handle',
					'mode' => 'tags'
				]
			], [
				'name' => 'Content',
				'slug' => 'content',
				'namespace' => 'blocks',
				'streams' => [
					'special_offer',
					'banner_promotion',
				],
				'type' => 'anomaly.field_type.textarea',
				'translatable' => true,
				'config' => [],
			], [
				'name' => 'Partial Image',
				'slug' => 'partial_image',
				'namespace' => 'blocks',
				'streams' => ['banner_promotion'],
				'type' => 'anomaly.field_type.file',
				'translatable' => true,
				'config' => [
					'folders' => ['images'],
					'mode' => 'upload',
				]
			], [
				'name' => 'URL',
				'slug' => 'url',
				'namespace' => 'blocks',
				'streams' => [
					'banner_promotion',
					'brands'
				],
				'type' => 'anomaly.field_type.url',
				'translatable' => false,
				'config' => []
			]
		];

		foreach ($blockFields as $blockField) {
			//Create Field
			$field = $this->fieldRepository->findBySlugAndNamespace($blockField['slug'], 'blocks');
			if (!$field) {
				$field = $this->fieldRepository->create([
					'name' => $blockField['name'],
					'namespace' => $blockField['namespace'],
					'slug' => $blockField['slug'],
					'type' => $blockField['type'],
					'locked' => 0,
					'config' => $blockField['config'],
				]);
			}

			//Assign Streams
			foreach ($blockField['streams'] as $stream) {
				$typeStream = $this->streamRepository->findBySlugAndNamespace($stream . '_blocks', 'blocks');

				if ($typeStream && !$this->assignmentRepository->findByStreamAndField($typeStream, $field)) {
					$this->assignmentRepository->create([
						'stream_id' => $typeStream->getId(),
						'field_id' => $field->getId(),
						'translatable' => $blockField['translatable']
					]);
				}
			}
		}

		// Create Post Field
		$field = $this->fieldRepository->findBySlugAndNamespace('image', 'posts');
		if (!$field) {
			$field = $this->fieldRepository->create([
				'name' => 'Image',
				'namespace' => 'posts',
				'slug' => 'image',
				'type' => 'anomaly.field_type.file',
				'locked' => 0,
				'config' => [
					'folders' => ['images'],
					'mode' => 'upload',
				],
			]);

			if ($postType = $this->postTypeRepository->findBySlug('default')) {
				$stream = $postType->getEntryStream();
				$this->assignmentRepository->create([
					'translatable' => true,
					'stream' => $stream,
					'field' => $field,
				]);
			}
		}
	}
}