var getEntryImages = {
    thumbs(entry) {
        return this.generate(entry, 'sm-image');
    },
    slider(entry) {
        return this.generate(entry, 'lg-image');
    },
    generate(entry, attr_class) {
        let images = "";

        if (entry.files.length > 0) {
            $.each(entry.files, function (index, value) {
                images += `<li><img src="/files/${value.path}" alt="${entry.name}"
                    width="${ attr_class === 'sm-image' ? 58 : 500 }" height="${ attr_class === 'sm-image' ? 58 : 500 }"></li>`;
            });
        } else {
            images = `<div class="${attr_class}"><img src="${entry.thumbnail}" alt="${entry.name}"></div>`;
        }
        return images;
    }
};

var getSocialLink = {
    linkedin(detail_url) {
        return "https://www.linkedin.com/sharing/share-offsite/?url=" + encodeURIComponent(detail_url);
    },
    whatsapp(detail_url) {
        return "https://wa.me/?text=" + encodeURIComponent(whatsapp_share_message) + "%20" + encodeURIComponent(detail_url);
    },
    facebook(detail_url) {
        return "https://www.facebook.com/sharer/sharer.php?u=" + encodeURIComponent(detail_url);
    },
    twitter(detail_url) {
        return "http://twitter.com/share?url=" + encodeURIComponent(detail_url);
    },
};

var initSlider = {
    slider(element, nav = null) {
        this.init(element, {
            arrows: false,
            dots: false,
            slidesMargin: 30,
            autoplay: false,
            autoplaySpeed: 5000,
            infinite: true,
            centerMode: false,
            centerPadding: 0,
            slidesToShow: 1,
            slidesToScroll: 1,
            fade: true,
            asNavFor: nav
        })
    },
    thumbnail(element, nav = null) {
        this.init(element, {
            arrows:false,
            dots:false,
            centerMode:false,
            infinite: true,
            autoplay: false,
            focusOnSelect: true,
            slidesMargin: 10,
            slidesToShow: 3,
            slidesToScroll: 1,
            asNavFor: nav
        })
    },
    init(element, options) {
        element.slick(options);
    }
};

function quickView(id) {
   let modal = $('#biolife-quickview-block');

    $('.product-variants').remove();


    let entry = getDetail(id);
    let initAdDetail = new Promise(function (response) {

         // Init Loader
        $('.quick-loader').removeClass('d-none');
        $('.quick-detail').addClass('d-none');

        // Set Detail
        modal.find('.title').html(`<a href="${entry.detail_url}">${entry.name}</a>`);
        modal.find('.excerpt').html(entry.advs_desc);
        modal.find('ins .price-amount').html(entry.currency_price);
        modal.find('del .price-amount').html(entry.currency_standard_price);
        modal.find('.category-list').html(entry.category1.name);
        modal.find('.category-list').append(' ' + entry.category2.name);
        modal.find('.add-to-cart-btn').attr('data-id', entry.id);

        // Add Images
        $('.biolife-quickview-inner .media').html(`
            <ul class="biolife-carousel-custom quickview-for">${getEntryImages.slider(entry)}</ul>
            <ul class="biolife-carousel-custom quickview-nav">${getEntryImages.thumbs(entry)}</ul>
        `);

        // Add Configuration
        if (entry.configurations && entry.configurations.length > 0) {
            let configuration_field = `<div class="product-variants"><div class="produt-variants-size"><label>Dimension<select class="configuration-select-${entry.id} wide"></label>`;

            // Each Configurations
            $.each(entry.configurations, function (index, value) {
                let selected = (index === 0) ? 'selected' : '';
                configuration_field += `<option value="${value.id}" title="${value.option_name}" ${selected}>${value.option_name}</option>`;
            });

            configuration_field += `</select></div></div>`;

            $('.from-cart .buttons').prepend(configuration_field);

            //Refresh Select Extension
            $('.configuration-select-' + entry.id).niceSelect();
        }

        // Init Social Links
        modal.find('.socail-btn.facebook').attr('href',getSocialLink.facebook(entry.detail_url));
        modal.find('.socail-btn.twitter').attr('href',getSocialLink.twitter(entry.detail_url));
        modal.find('.socail-btn.linkedin').attr('href',getSocialLink.linkedin(entry.detail_url));
        modal.find('.socail-btn.whatsapp').attr('href',getSocialLink.whatsapp(entry.detail_url));

        response(true);
    });
    // Remove Loader
    initAdDetail.then(function () {
        $('.quick-loader').addClass('d-none');
        $('.quick-detail').removeClass('d-none');

        $('.biolife-quickview-inner .media').find('.quickview-for').html(`${getEntryImages.slider(entry)}`)
            .siblings(`.quickview-nav`).html(`${getEntryImages.thumbs(entry)}`);

        initSlider.slider($('.biolife-carousel-custom.quickview-for'), $('.biolife-carousel-custom.quickview-nav'))
        initSlider.thumbnail($('.biolife-carousel-custom.quickview-nav'), $('.biolife-carousel-custom.quickview-for'))
    });
}


function getDetail(id) {
    let entry = null;

    //Get Detail
    crudAjax('', '/api/entries/advs/advs/' + id, 'GET', function (response) {
        if (response.data) {
            entry = response.data;
        }
    });

    if (entry) {
        // Get Images
        crudAjax('', '/api/entries/advs/advs/' + id + '/files/get', 'GET', function (response) {
            if (response.data) {
                entry.files = response.data;
            }
        });

        // Get Configurations
        crudAjax('', '/api/entries/advs/advs/' + id + '/configurations/get', 'GET', function (response) {
            if (response.data) {
                entry.configurations = response.data;
            }
        });
    }

    return entry;
}

