<?php namespace Visiosoft\BiddingModule\Seeders;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;

class NotificationTemplatesSeeder extends Seeder
{
    use DispatchesJobs;

    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {

            $templates = [
                [
                    'en' => [
                        'message' => '<p style="color: #707070; font-size: 16px;">#{product_id} numaralı <b>{product_name}</b> ilanına <b>{bidder_name} </b> tarafından yeni bir teklif geldi.Detaylar için lütfen panelinizi kontrol ediniz.</p>
                                      
                                      <h3 style="color: #2F3133;">Yeni teklif {new_bid_price}</h3>
                                      
                                      <p style="color: #707070;">Teşekkürler</p>',
                        'name' => 'New Offer Submitted | Bidding Module',
                        'subject' => '{product_name} ilanınıza yeni bir fiyat teklifi geldi!',
                        'greeting' => 'Merhaba {display_name},'
                    ],
                    'stream' => 'bidding',
                    'slug' => Str::slug('New Offer Submitted', '_')
                ],
                [
                    'en' => [
                        'message' => '<p style="color: #707070; font-size: 16px;">#{product_id} numaralı <b>{product_name}</b> ilan teklifiniz satıcı tarafından onaylandı.Detaylar için lütfen siparişlerinizi kontrol ediniz.</p>
                                        <a href="{purchase_url}" style="text-decoration: none"><h3 style="color: #2F3133">Siparişlerime Git</h3></a>
                                        <p style="color: #707070;">Teşekkürler</p>',
                        'name' => 'Your bid has been approved | Buyer | Bidding Module',
                        'subject' => '{product_name} ilanına yaptığınız teklif onaylandı!',
                        'greeting' => 'Merhaba {display_name},'
                    ],
                    'stream' => 'bidding',
                    'slug' => Str::slug('Your bid has been approved | Buyer', '_')
                ],
                [
                    'en' => [
                        'message' => '<p style="color: #707070; font-size: 16px;">#{product_id} numaralı <b>{product_name}</b> ilan teklifini onayladınız.Detaylar için lütfen satışlarım ekranını kontrol ediniz.</p>
                                        <a href="{sales_url}" style="text-decoration: none"><h3 style="color: #2F3133">Satışlarıma Git</h3></a>
                                        <p style="color: #707070;">Teşekkürler</p>',
                        'name' => 'You have approved the offer | Seller | Bidding Module',
                        'subject' => '{product_name} teklifi onayladınız!',
                        'greeting' => 'Merhaba {display_name},'
                    ],
                    'stream' => 'bidding',
                    'slug' => Str::slug('You have approved the offer | Seller', '_')
                ],
                [
                    'en' => [
                        'message' => '<p style="color: #707070; font-size: 16px;">#{product_id} numaralı <b>{product_name}</b> ilan teklifinizin süresi doldu.Detaylar için lütfen tekliflerim ekranını kontrol ediniz.</p>
                                        <a href="{my_offers_url}" style="text-decoration: none"><h3 style="color: #2F3133">Tekliflerime Git</h3></a>
                                        <p style="color: #707070;">Teşekkürler</p>',
                        'name' => 'Offer Expired | Bidding Module',
                        'subject' => '{product_name} teklifinizin süresi doldu!',
                        'greeting' => 'Merhaba {display_name},'
                    ],
                    'stream' => 'bidding',
                    'slug' => Str::slug('Offer Expired', '_')
                ],
            ];


            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }
        }
    }
}
