<?php namespace Visiosoft\BiddingModule\Seeders;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class CustomFieldsSeeder extends Seeder
{

    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customfield_value_repository = app(CfvalueRepositoryInterface::class);

            if (!$customFieldRepository->findBySlug('is_made_bid')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'is_made_bid',
                        'name' => 'Teklif Verilebilir mi',
                        'type' => 'select',
                        'required' => true
                    ]
                );

                $cf_values = [
                    [
                        'custom_field_value' => 'No',
                        'custom_field_id' => $customfield->getId(),
                    ],
                    [
                        'custom_field_value' => 'Yes',
                        'custom_field_id' => $customfield->getId(),
                    ]
                ];

                foreach ($cf_values as $cf_value) {
                    $customfield_value_repository->newQuery()->create($cf_value);
                }
            }            
        }
    }

}
