<?php namespace Visiosoft\BiddingModule\Provision\Form;

use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Message\MessageBag;

class GiveUserProvisionFormHandler
{
    public $entry;

    public function handle(GiveUserProvisionFormBuilder $builder, MessageBag $messages)
    {        
        // user
        $user = $builder->getFormValue('user');
        
        $provisions = app(ProvisionRepository::class);

        $provision = $provisions->create([
            'created_by_id' => $user,
            'provision_status' => 'free',
            'price' => setting_value('visiosoft.module.bidding::provision_price'),
            'currency' => setting_value('streams::currency'),
            'given_from_admin' => true,
        ]);        

        $messages->success(trans("visiosoft.module.bidding::message.provisionHasBeenGivenToUser"));
    }
}
