<?php namespace Visiosoft\BiddingModule\Offer\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\BiddingModule\Offer\Command\RemoveApprovableAnotherOffers;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Illuminate\Routing\Redirector;
use Symfony\Component\HttpFoundation\Response;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class OfferFormHandler 
{
    use DispatchesJobs;

    public function handle(
        OfferFormBuilder $builder,
        AdvRepositoryInterface $advRepository,
        MessageBag $message,
        ScaleRepositoryInterface $scaleRepository,
        ProvisionRepositoryInterface $provisionRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        Redirector $redirect,
        Response $response,
        OfferRepositoryInterface $repository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $entry_id = $builder->getEntry();

        if ($entry_id) {
            $adv = $advRepository->find($entry_id);
        }
        if ((auth()->user() and auth()->user()->hasRole('admin')) or
            ($adv && ((!$adv->expired() && $adv->getStatus() === 'approved') ||
                    $adv->created_by_id === \auth()->id()))) {

            $amount_entered = $builder->getPostValue('bid_price');

            $scale_entry = $scaleRepository->findBetweenScale($amount_entered);

            $bid_price = ($scale_entry) ? floor($amount_entered / $scale_entry->amount_of_increase) * $scale_entry->amount_of_increase : $amount_entered;

            $last_offer_price = $adv->standard_price;

            if ($last_offer = $repository->getLastOfferByAd($adv->id)) {
                $last_offer_price = $last_offer->bid_price;
            }

            if ($bid_price <= $last_offer_price) {
                $message->error(trans('visiosoft.module.bidding::message.higher_offer_previous_offer'));
                return;
            }

            $freePrevision = $provisionRepository->getFreePrevision();
            if (count($freePrevision) === 0) {
                $message->warning(trans('visiosoft.module.bidding::message.mustBuyProvisionToContinue'));
                $builder->setFormResponse($redirect->route('provision:buy', 
                ['advIdToBeOffered' => $adv->id, 
                'offerPrice' => $bid_price,
                'buyNowPrice' => $adv->price]));
                return;
            }

            // The user has a free provision. So we can continue to save the offer that the user has sent.            

            $entry = $repository->newCreate([
                'parent_adv' => $adv,
                'bid_price' => $bid_price,
                'str_id' => str_random(24),
                'approvable' => true,
            ]);

            // update the status of other offers
            $this->dispatch(new RemoveApprovableAnotherOffers($entry));

            $previousLinkedProvision = $provisionRepository->newQuery()->
            where('related_adv_id', $adv->id)->where('provision_status', 'linked')->first();

            if (!is_null($previousLinkedProvision)) {
                $previousLinkedProvision->update([
                    'provision_status' => 'free',
                    'related_adv' => null,
                    'offer_price' => null,
                    'offer_of_provision_id' => null,
                ]);            
            }

            $freeProvisionRepositories = $provisionRepository->newQuery()->where('provision_status', 'free')->
            where('created_by_id', auth()->user()->id)->orderBy('created_at', 'asc');

            $freeProvisionRepositories->first()->update([
                'provision_status' => 'linked',
                'offer_of_provision_id' => $entry->id,
                'related_adv_id' => $adv->id,
                'offer_price' => $bid_price,
            ]);

            $message->success(trans('visiosoft.module.bidding::message.success_offer'));

            event(new NewOfferSubmitted($entry));

        } else {
            $message->error(trans('visiosoft.module.advs::message.ad_doesnt_exist'));
            return;
        }
    }
}
