<?php namespace Visiosoft\BiddingModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Illuminate\Http\Request;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class ProvisionController extends PublicController
{
    protected $provisionRepository;
    private $advRepository;

    public function __construct(
        ProvisionRepositoryInterface $provisionRepository,
        AdvRepositoryInterface $advRepository)
    {
        $this->provisionRepository = $provisionRepository;
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function changeStatusToRequsted($id)
    {
        $requestedProvision = $this->provisionRepository->find($id);
        $requestedProvision->update([
            'provision_status' => 'requstedBack',
        ]);

        $this->messages->success(trans('visiosoft.module.bidding::field.request_received'));

        return redirect()->route('visiosoft.module.bidding::profile.my_provisions');
    }

    public function buyProvision($advIdToBeOffered, $offerPrice, $buyNowPrice)
    {
        return $this->view->make('visiosoft.module.bidding::provision/buy-provision', 
        compact('advIdToBeOffered', 'offerPrice', 'buyNowPrice'));
    }

    public function prepareToAddToCart(Request $request)
    {
        $relatedAdvId = $request->related_adv_id;

        $relatedAdv = $this->advRepository->find($relatedAdvId);

        $provision = $this->provisionRepository->create([
            'provision_status' => 'pending',
            'related_adv' => $relatedAdv,
            'offer_price' => $request->offer_price,
            'price' => setting_value('visiosoft.module.bidding::provision_price'),
            'currency' => setting_value('streams::currency'),
        ]);

        $provisionToBeAddedToTheCart = $this->provisionRepository->find($provision->id);

        $provisionName = $request->provision_name;

        $this->addCart($provisionToBeAddedToTheCart, $provisionName);

        return redirect()->route('visiosoft.module.carts::cart');
    }

    public function addCart($provisionToBeAddedToTheCart, $provisionName)
    {
        $cart = $this->dispatch(new GetCart());
        $cart->add($provisionToBeAddedToTheCart, 1, $provisionName);

        $provisionToBeAddedToTheCart->update([
            'provision_status' => 'in_cart',
        ]);
    }
}
