let Auction = {
    minimum: $('#auction-widget').data('starting-price'),
    maximum: $('#auction-widget').data('buy-it-now-price'),
    send: function (price = null) {
        if (!price) {
            price = $('#auction-widget .auction-input').val();
            price = price.replace(/[^0-9]+/g, '');
        }

        let entry_id = $('#auction-widget').data('entry-id');

        // Send Request
        $.ajax({
            type: 'POST',
            data: {'entry_id': entry_id, 'price': price},
            async: false,
            url: '/handle/append-bid',
            success: function (response) {
                $.each(response.message, function (i, field) {
                    $.each(field, function (i, message) {
                        Toast.fire(message, response.success ? 'success' : 'error');
                    });
                });

                Auction.minimum = price;

                $('#auction-widget .auction-add-btn').attr('disabled', true);

                // Update List
                Auction.refresh(entry_id);
            },
            error: function (xhr) {
                $.each(xhr.responseJSON.message, function (i, field) {
                    $.each(field, function (i, message) {
                        Toast.fire(message, 'error');
                    });
                });
            }
        })
    },
    refresh: function (id) {
        let currency_symbol = $('#auction-widget').data('currency-symbol');
        $.ajax({
            type: 'POST',
            data: {'entry_id': id, 'currency': currency_symbol},
            async: false,
            url: '/handle/list-bids',
            success: function (response) {
                $('#auction-widget .auction-list').html(response);

                let last_bid_price = $('#auction-widget .auction-list .auction-bid-item .auction-price').first().html();
                Auction.minimum = parseInt(last_bid_price.replace(/[^0-9]+/g, ''));
            },
            error: function (xhr) {
                $.each(xhr.responseJSON.message, function (i, field) {
                    $.each(field, function (i, message) {
                        Toast.fire(message, 'error');
                    });
                });
            }
        })
    }
};

$(function () {
    $("#auction-widget .auction-input").on('input', function () {
        let value = parseInt($(this).val().replace(/[^0-9]+/g, ''));

        if (value > parseInt(Auction.minimum) && value < parseInt(Auction.maximum)) {
            $('#auction-widget .auction-add-btn').removeAttr('disabled');
        } else {
            $('#auction-widget .auction-add-btn').attr('disabled', true);
        }
    });

    $("button[data-action='auto-price']").on('click', function () {
        let price = parseInt($(this).data('price')) + Auction.minimum;

        Auction.send(price);
    });

    $("#auction-widget .auction-input").inputmask('decimal', {
        integerDigits: 10,
        autoGroup: true,
        groupSeparator: ".",
        radixPoint: ",",
        placeholder: "0",
    });

    setInterval(function () {
        Auction.refresh($('#auction-widget').data('entry-id'));
    }, 1000);
})