<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\BiddingModule\Offer\Events\OfferExpired;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;

class ValidOfferExpired
{
    private $provisionRepository;
    private $offerRepository;
    
    public function __construct(ProvisionRepository $provisionRepository,
    OfferRepositoryInterface $offerRepository
    )
    {
        $this->provisionRepository = $provisionRepository;
        $this->offerRepository = $offerRepository;
    }

    public function handleValidOfferExpire(OfferExpired $entry)
    {
        $provisionToMakeFree = $this->provisionRepository->newQuery()->
        where('offer_of_provision_id', $entry->getOffer()->id)->
        where('provision_status', 'linked')->
        first();

        if ($provisionToMakeFree) {
            $provisionToMakeFree->update([
                'provision_status' => 'free',
                'related_adv' => null,
                'offer_price' => null,
                'offer_of_provision_id' => null,
            ]);
        }
    }
}