<?php namespace Visiosoft\BiddingModule\Listeners;

use Anomaly\Streams\Platform\Ui\Form\Event\FormWasPosted;
use Visiosoft\BiddingModule\AdDetail\Contract\AdDetailRepositoryInterface;

class SaveBidEntryForAdvs
{
    protected $repository;

    public function __construct(AdDetailRepositoryInterface $repository)
    {
        $this->repository = $repository;
    }

    public function handle(FormWasPosted $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) === 'Visiosoft\AdvsModule\Adv\Form\AdvFormBuilder') {
            if ($builder->getRequestValue('pricing-format') === 'auction') {
                $fields = [
                    'auction_duration',
                    'starting_bid_price',
                    'reserve_price'
                ];

                $entry = $this->repository->findByEntryID($builder->getFormEntryId()) ?: $this->repository->getModel();
                $entry->setAttribute('entry_id', $builder->getFormEntryId());
                $entry->setAttribute('buy_it_now_price', $builder->getRequestValue('price'));
                $entry->setAttribute('currency', $builder->getFormEntry()->getAttribute('currency'));

                foreach ($fields as $field) {
                    $entry->setAttribute($field, $builder->getRequestValue($field));
                }

                $entry->save();
            }
        }
    }
}
