<?php namespace Visiosoft\BiddingModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Visiosoft\BiddingModule\AdDetail\Contract\AdDetailRepositoryInterface;
use Visiosoft\BiddingModule\AdDetail\AdDetailRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingAdDetailEntryModel;
use Visiosoft\BiddingModule\AdDetail\AdDetailModel;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Bidding\BiddingProvisionsEntryModel;
use Anomaly\Streams\Platform\Ui\Form\Event\FormWasPosted;
use Visiosoft\BiddingModule\Listeners\SaveBidEntryForAdvs;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\OfferRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingOffersEntryModel;
use Visiosoft\BiddingModule\Offer\OfferModel;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Visiosoft\BiddingModule\Provision\ProvisionModel;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\BiddingModule\Offer\Events\OfferExpired;

class BiddingModuleServiceProvider extends AddonServiceProvider
{

    protected $plugins = [
        BiddingModulePlugin::class,
    ];

    protected $routes = [
        'handle/append-bid' => [
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\AuctionController@appendBid',
            'middleware' => 'auth',
            'verb' => 'POST'
        ],
        'handle/list-bids' => [
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\AuctionController@bids',
            'middleware' => 'auth',
            'verb' => 'POST'
        ],
        'profile/bidding/my-auction-items' => [
            'as' => 'visiosoft.module.bidding::my_auction_items',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\AuctionController@myAuctionItems',
            'middleware' => 'auth',
        ],
        'profile/bidding/purchased' => [
            'as' => 'visiosoft.module.bidding::purchased',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\AuctionController@purchased',
            'middleware' => 'auth',
        ],
    ];

    protected $listeners = [
        OfferExpired::class => [
            '\Visiosoft\BiddingModule\Provision\Listener\ValidOfferExpired@handleValidOfferExpire',
        ],
        FormWasPosted::class => [
            SaveBidEntryForAdvs::class
        ],
    ];

    protected $bindings = [
        BiddingAdDetailEntryModel::class => AdDetailModel::class,
        BiddingOffersEntryModel::class => OfferModel::class,
        BiddingProvisionsEntryModel::class => ProvisionModel::class,
    ];

    protected $singletons = [
        AdDetailRepositoryInterface::class => AdDetailRepository::class,
        OfferRepositoryInterface::class => OfferRepository::class,
        ProvisionRepositoryInterface::class => ProvisionRepository::class,
    ];

    protected $overrides = [
        'visiosoft.module.advs::new-ad/price-area' => 'visiosoft.module.bidding::addons/visiosoft/advs-module/new-ad/price-area',
    ];

    public function boot(AddonCollection $addonCollection)
    {
        $settings_url = [
            'bidding_settings' => [
                'title' => 'visiosoft.module.bidding::button.bidding_settings',
                'href' => '/admin/settings/modules/visiosoft.module.bidding',
                'page' => 'visiosoft.module.bidding'
            ],
        ];

        foreach ($settings_url as $key => $value) {
            $addonCollection->get($value['page'])->addSection($key, $value);
        }
    }
}
