<?php namespace Visiosoft\BiddingModule\AdDetail;

use Visiosoft\BiddingModule\AdDetail\Contract\AdDetailRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class AdDetailRepository extends EntryRepository implements AdDetailRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var AdDetailModel
     */
    protected $model;

    /**
     * Create a new AdDetailRepository instance.
     *
     * @param AdDetailModel $model
     */
    public function __construct(AdDetailModel $model)
    {
        $this->model = $model;
    }

    public function findByEntryID($entry_id)
    {
        return $this->newQuery()->where('entry_id', $entry_id)->first();
    }
}
